#SingleInstance, Force
#Persistent
#NoEnv
ListLines, Off
SetBatchLines, -1

Ico = %A_ScriptDir%\IMECur.ico
Ini = %A_ScriptDir%\IMECur.ini
Ver = 0.71
Link = http://saury.tistory.com/
SettingList =
(Join LTrim
GetIMEStatus,1,2,1|
ShowEnglishIBeam,0,1,1|
ShowJapaneseIBeam,0,1,1|
ShowKoreanIBeam,0,1,1|
PlayEnglishSound,0,1,1|
PlayJapaneseSound,0,1,1|
PlayKoreanSound,0,1,1|
ShowIMETrayIcon,0,1,1|
PlaySounds,0,1,1
)
Loop, Parse, SettingList, |
{
	StringSplit, $, A_LoopField, `,
	IniRead, %$1%, %Ini%, Settings, %$1%, %A_Space%
	If %$1% Is Integer
		If %$1% Between %$2% And %$3%
			Continue
	%$1% := $4
}
Menu, Tray, UseErrorLevel
Menu, Tray, NoStandard
Menu, Tray, Add, Ҹ (&P), MenuPlaySounds
Menu, Tray, Add
Menu, Tray, Add, (&S), MenuSettings
Menu, Tray, Add
Menu, Tray, Add, (&A), MenuAbout
Menu, Tray, Add
Menu, Tray, Add, (&X), MenuExit
Menu, Tray, Default, Ҹ (&P)
Menu, Tray, Icon, % A_IsCompiled ? A_ScriptFullPath : Ico
Menu, Tray, Tip, IME Cursor
Menu, Tray, % PlaySounds = 1 ? "Check" : "UnCheck", Ҹ (&P)
SetTimer, IMECheckTimer, 100
Return

MenuPlaySounds:
PlaySounds := !PlaySounds
Menu, Tray, % PlaySounds = 1 ? "Check" : "UnCheck", Ҹ (&P)
IniWrite, %PlaySounds%, %Ini%, Settings, PlaySounds
Return

MenuSettings:
Gui, 1:+LastFoundExist
IfWinExist
{
	WinActivate
	Return
}
Gui, 2:+LastFoundExist
IfWinExist,,, Gosub, 2GuiClose
Gui, 1:-MinimizeBox
Gui, 1:Margin, 10, 10
Gui, 1:Font, s9, Gulim
Gui, 1:Add, GroupBox, xm ym w240 h230, 
Gui, 1:Add, Text, xp+15 yp+25 h15, IME  :
Gui, 1:Add, DropDownList, xp y+2 w210 r2 AltSubmit Choose%GetIMEStatus% vGetIMEStatus, Ȱ â Ŀ̵ Ʈ|콺 Ŀ ġ Ʈ
Gui, 1:Add, CheckBox, xp y+13 h15 Checked%ShowEnglishIBeam% vShowEnglishIBeam,  Ŀ ǥ
Gui, 1:Add, CheckBox, xp y+5 hp Checked%ShowJapaneseIBeam% vShowJapaneseIBeam, Ϻ Ŀ ǥ
Gui, 1:Add, CheckBox, xp y+5 hp Checked%ShowKoreanIBeam% vShowKoreanIBeam, ѱ Ŀ ǥ
Gui, 1:Add, CheckBox, xp y+5 hp Checked%PlayEnglishSound% vPlayEnglishSound,  Ҹ 
Gui, 1:Add, CheckBox, xp y+5 hp Checked%PlayJapaneseSound% vPlayJapaneseSound, Ϻ Ҹ 
Gui, 1:Add, CheckBox, xp y+5 hp Checked%PlayKoreanSound% vPlayKoreanSound, ѱ Ҹ 
Gui, 1:Add, CheckBox, xp y+5 hp Checked%ShowIMETrayIcon% vShowIMETrayIcon, IME Ʈ  ǥ
Gui, 1:Add, Button, xm+85 ym+250 w75 h25 Default gButtonOK, Ȯ
Gui, 1:Add, Button, x+5 yp wp hp gButtonCancel, 
Gui, 1:Show,, IME Cursor 
Return

ButtonOK:
Gui, 1:Submit, NoHide
Loop, Parse, SettingList, |
{
	StringSplit, $, A_LoopField, `,
	IniWrite, % %$1%, %Ini%, Settings, %$1%
}
If (ShowIMETrayIcon = 0)
	SetTrayIcon()
Gui, 1:Destroy
Return

GuiClose:
GuiEscape:
ButtonCancel:
Gui, 1:Destroy
Return

MenuAbout:
Gui, 2:+LastFoundExist
IfWinExist
{
	WinActivate
	Return
}
Gui, 1:+LastFoundExist
IfWinExist,,, Gosub, GuiClose
Gui, 2:-MinimizeBox
Gui, 2:Margin, 10, 10
Gui, 2:Font, s9, Gulim
Gui, 2:Add, GroupBox, xm ym w240 h120
Gui, 2:Add, Picture, xp+15 yp+25 w32 h32 Icon1, % A_IsCompiled ? A_ScriptFullPath : Ico
Gui, 2:Add, Text, x+23 yp h15, IME Cursor %Ver%
Gui, 2:Add, Text, xp y+5 hp, // 콺 Ŀ
Gui, 2:Font, Underline
Gui, 2:Add, Text, xp y+25 h15 cBlue vLink gTextLink, %Link%
Gui, 2:Font, Normal
Gui, 2:Add, Button, xm+165 ym+140 w75 h25 Default g2ButtonClose, ݱ
Gui, 2:Show,, IME Cursor 
OnMessage(0x20, "WM_MOUSEMOVE")
OnMessage(0x200, "WM_MOUSEMOVE")
Return

TextLink:
GuiControlGet, hLink, 2:Hwnd, Link
KeyWait, LButton
MouseGetPos,,,, hCtrl, 2
IfEqual, hCtrl, %hLink%, Run, %Link%,, UseErrorLevel
Return

2GuiClose:
2GuiEscape:
2ButtonClose:
Gui, 2:Destroy
Return

MenuExit:
DllCall("SystemParametersInfo", "UInt", 87, "UInt", 0, "UInt", 0, "UInt", 0)
ExitApp

IMECheckTimer:
ShowIME(GetIME(GetIMEStatus))
Return

WM_MOUSEMOVE(wParam, lParam, uMsg)
{
	Static Hover, HandCur, OldCur
	IfNotEqual, A_Gui, 2, Return
	If (uMsg = 0x20 && Hover = 1)
		Return, 1
	Else If (uMsg = 0x200)
	{
		If (A_GuiControl = "Link")
		{
			If (Hover = "")
			{
				HandCur := DllCall("LoadCursor", "UInt", 0, "UInt", 32649)
				Hover = 1
			}
			OldCur := DllCall("SetCursor", "UInt", HandCur)
		}
		Else If (Hover = 1)
		{
			DllCall("SetCursor", "UInt", OldCur)
			Hover =
		}
	}
}

GetIME(GetIMEStatus= 1)
{
	If (GetIMEStatus = 1)
	{
		VarSetCapacity(GuiThreadInfo, 48, 0)
		NumPut(48, GuiThreadInfo, 0)
		DllCall("GetGUIThreadInfo", "UInt", 0, "UInt", &GuiThreadInfo)
		hWnd := NumGet(GuiThreadInfo, 12)
	}
	Else If (GetIMEStatus = 2)
	{
		MouseGetPos,,, hWnd, hCtrl, 2
		hWnd := hCtrl ? hCtrl : hWnd
	}
	If (hWnd)
	{
		IMEWnd := DllCall("imm32.dll\ImmGetDefaultIMEWnd", "UInt", hWnd)
		IME := (DllCall("SendMessage", "UInt", IMEWnd, "UInt", 0x283, "Int", 5, "Int", 0)) ; WM_IME_CONTROL = 0x283, IMC_GETOPENSTATUS = 5
			? DllCall("SendMessage", "UInt", IMEWnd, "UInt", 0x283, "Int", 1, "Int", 0) : 0 ; IMC_GETCONVERSIONMODE = 1
	}
	Return, IME
}

ShowIME(IME = 0)
{
	Global
	Static OldIME, OldCaps, OldShift
	Local Caps, Shift
	Caps := GetKeyState("Capslock", "T")
	Shift := GetKeyState("Shift", "P")
	If (IME <> OldIME || Caps <> OldCaps || Shift <> OldShift)
	{
		If IME In 0,8,16,24
		{
			SetCursor(ShowEnglishIBeam = 1 ? Caps + Shift = 1 ? "EU" : "EL" : "")
			SetTrayIcon(ShowIMETrayIcon = 1 ? "E" : "")
		}
		Else If IME In 9,25
		{
			SetCursor(ShowJapaneseIBeam = 1 ? "JH" : "")
			SetTrayIcon(ShowIMETrayIcon = 1 ? "J" : "")
		}
		Else If IME In 3,11,19,27
		{
			SetCursor(ShowJapaneseIBeam = 1 ? "JK" : "")
			SetTrayIcon(ShowIMETrayIcon = 1 ? "J" : "")
		}
		Else If IME = 1
		{
			SetCursor(ShowKoreanIBeam = 1 ? "K" : "")
			SetTrayIcon(ShowIMETrayIcon = 1 ? "K" : "")
		}
		Else
		{
			SetCursor()
			SetTrayIcon()
		}
		If (PlaySounds = 1)
		{
			If IME In 0,8,16,24
			{
				If OldIME Not In 0,8,16,24
					IfEqual, PlayEnglishSound, 1, SoundPlay, %A_ScriptDir%\IMEE.wav
			}
			Else If IME In 3,9,11,19,25,27
			{
				If OldIME Not In 3,9,11,19,25,27
					IfEqual, PlayJapaneseSound, 1, SoundPlay, %A_ScriptDir%\IMEJ.wav
			}
			Else If (IME = 1 && OldIME <> 1)
				IfEqual, PlayKoreanSound, 1, SoundPlay, %A_ScriptDir%\IMEK.wav
		}
		OldIME := IME
		OldCaps := Caps
		OldShift := Shift
	}
}

SetCursor(Type = "")
{
	If (Type = "EL")
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE0000001000000010000000100000001000000010000000100000001000000010000
		000101E00001003000010030000101F00001033000010330000EE1F0000000000000000000000000000000000000000000000000000000000000000000000000
		)
	}
	Else If (Type = "EU")
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE000000100000001000000010000000100000001000000010000000100C0000101E0
		000103300001033000010330000103F00001033000010330000EE330000000000000000000000000000000000000000000000000000000000000000000000000
		)
	}
	Else If (Type = "JH")
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE000000100000001000000010000000100000001000000010000000100C0000100F0
		000103C0000100D8000101FC000103F6000106E6000106C6000EE39C000000000000000000000000000000000000000000000000000000000000000000000000
		)
	}
	Else If (Type = "JK")
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE0000001000000010000000100000001000000010000000100000001006000010060
		000103FC0001006C0001006C000100CC000100CC0001018C000EE338000000000000000000000000000000000000000000000000000000000000000000000000
		)
	}
	Else If (Type = "K")
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE000000100000001000000010000000100000001000000010000000107EC0001006C
		0001006C0001006C0001006F000100CC000100CC0001018C000EE70C0000000C0000000000000000000000000000000000000000000000000000000000000000
		)
	}
	Else
	{
		XorStr =
		(Join LTrim
		00000000000000000000000000000000000000000000000000000000000EE0000001000000010000000100000001000000010000000100000001000000010000
		000100000001000000010000000100000001000000010000000EE000000000000000000000000000000000000000000000000000000000000000000000000000
		)
	}
	nSize := StrLen(XorStr) // 2
	VarSetCapacity(AndMask, nSize, 0xFF)
	VarSetCapacity(XorMask, nSize, 0)
	Loop, %nSize%
		NumPut("0x" . SubStr(XorStr, A_Index * 2 - 1, 2), XorMask, A_Index - 1, "Char")
	hCur := DllCall("CreateCursor", "UInt", 0, "Int", 15, "Int", 15, "Int", 32, "Int", 32, "UInt", &AndMask, "UInt", &XorMask)
	DllCall("SetSystemCursor", "UInt", hCur, "UInt", 32513)
	DllCall("DestroyCursor", "UInt", hCur)
}

SetTrayIcon(Type = "")
{
	If (Type = "E")
	{
		IconStr =
		(Join LTrim
		28000000100000002000000001000400000000000000000000000000000000000000000000000000000000000000800000800000008080008000000080008000
		80800000C0C0C000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF0088888880000000008FFFFF00000000008F0FFA2000000A20
		8F007A220000A2208F000FA20000A2008F0780A2222222008F07808A200A20008F07780A20AA20008FF07800A20200008F707780A22200008FFF07800A200000
		888807000A200000000000780000000000000077800000000000000780000000000000000000000001FF00000078000000780000007000000001000000010000
		00230000000300000107000000070000008F0000000F0000F80F0000F83F0000FC3F0000FC7F0000
		)
	}
	Else If (Type = "J")
	{
		IconStr =
		(Join LTrim
		28000000100000002000000001000400000000000000000000000000000000000000000000000000000000000000800000800000008080008000000080008000
		80800000C0C0C000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF0000000000800000000000000000070000000000000000F000
		000000080008F800000091100008FF80009910001108FF70099109999918FF780991199999187F809999199999918F009999999999910110D999999999910310
		D9999999999109100D999999999003100FD999999990091000FD9999990003100000DD9900000910FF030000FE010000FE010000FC610000F0600000C0200000
		8000000080000000000100000009000000090000000900008019000080190000C0390000F0F90000
		)
	}
	Else If (Type = "K")
	{
		IconStr =
		(Join LTrim
		28000000100000002000000001000400000000000000000000000000000000000000000000000000000000000000800000800000008080008000000080008000
		80800000C0C0C000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF0088888880000000008FFFFF800000D9008F0FFF399000D900
		8F007F8DD900D9008F000F80D990D9008F0780800D90D9908F0780800D90D9D08F0778000D90D9008FF078099990D9008F707780DDD0DD008FFF078000000000
		8888070000000000000000780000000000000077800000000000000780000000000000000000000001F100000071000000310000001100000100000001800000
		0180000000010000000100000001000000FF0000007F0000F87F0000F83F0000FC3F0000FC7F0000
		)
	}
	Else
	{
		IconStr =
		(Join LTrim
		28000000100000002000000001000400000000000000000000000000000000000000000000000000000000000000800000800000008080008000000080008000
		80800000C0C0C000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF0088888888888880008FFFFF8FFFFF80008F0FFF8FFFFF8000
		8F007F8F777F80008F000F8FFFFF80008F07808F777F80008F07808FFFFF80008F07780F777F80008FF0780FFFFF80008F707780777F80008FFF0780FFFF8000
		88880700088880000000007800000000000000778000000000000007800000000000000000000000000700000007000000070000000700000007000000070000
		000700000007000000070000000700000007000000070000F87F0000F83F0000FC3F0000FC7F0000
		)
	}
	nSize := StrLen(IconStr) // 2
	VarSetCapacity(IconData, nSize, 0)
	Loop, %nSize%
		NumPut("0x" . SubStr(IconStr, A_Index * 2 - 1, 2), IconData, A_Index - 1, "Char")
	hIcon := DllCall("CreateIconFromResourceEx", "UInt", &IconData, "UInt", 0, "Int", 1, "UInt", 196608, "Int", 16, "Int", 16, "UInt", 0)
	pid := DllCall("GetCurrentProcessId")
	VarSetCapacity(nid, 444, 0)
	NumPut(444, nid)
	DetectHiddenWindows, On
	NumPut(WinExist("ahk_class AutoHotkey ahk_pid " . pid), nid, 4)
	DetectHiddenWindows, Off
	NumPut(1028, nid, 8)
	NumPut(2, nid, 12)
	NumPut(hIcon, nid, 20)
	DllCall("shell32.dll\Shell_NotifyIcon", "UInt", 1, "UInt", &nid)
	DllCall("DestroyIcon", "UInt", hIcon)
}
