@echo off
chcp 65001 > nul
setlocal enabledelayedexpansion

REM 상위 폴더 경로 설정
set "parentFolder=D:\새 폴더 (2)"
REM 폴더 존재 확인
if not exist "%parentFolder%" (
    echo 폴더가 존재하지 않습니다.
    exit /b
)

REM 특수문자가 있으면 에러 발생 가능하다고 경고만 표시
echo.
echo ⚠ 경고: 폴더 이름에 '^^!'또는 '^^^^'가 포함되어 있을 경우 오류가 발생할 수 있습니다.
echo 계속 진행하시겠습니까? (작업을 취소하려면 N을 누르세요.)
echo.
choice /c YN /m "계속 진행하시겠습니까? (Y=예, N=아니오)"
if errorlevel 2 (
    echo 작업을 취소합니다.
    exit /b
)

REM 정상적으로 진행
echo 모든 폴더를 검사 완료. 파일 이름을 변경합니다...
echo.

REM 하위 폴더 순회
for /d %%F in ("%parentFolder%\*") do (
    echo 처리 중: %%F
    set "count=1"

    REM 해당 폴더의 모든 파일 처리
    for %%A in ("%%F\*.*") do (
        REM 4자리 숫자로 만들기 (예: 0001, 0002, ...)
        set "newName=0000!count!"
        set "newName=!newName:~-4!"

        REM 확장자 추출
        for %%X in ("%%A") do set "ext=%%~xX"

        REM 파일명 변경 (기존 위치에서)
        ren "%%A" "!newName!!ext!"
        echo "%%A" → "!newName!!ext!"

        REM 카운트 증가
        set /a count+=1
    )
)

echo 모든 파일 이름 변경 완료!
pause
