﻿#NoEnv  ; Recommended for performance and compatibility with future AutoHotkey releases

; Official repo:
; https://github.com/selfiens/KorTooltip

; References:
; IME state reader: https://iamaman.tistory.com/1805
; Persistent tooltip https://stackoverflow.com/questions/41598616/toggling-a-persistent-tooltip

; commands https://www.autohotkey.com/docs/commands/
; hotkeys https://www.autohotkey.com/docs/Hotkeys.

; # win
; ! alt
; ^ ctrl
; + shift

; ----------------------------------------------------------------
; Initializer >>>

isActive := True

InitTrayMenu()
StartWatch()
return
; <<< Initializer
; ----------------------------------------------------------------


; ----------------------------------------------------------------
; toggle tooltip state
#ScrollLock:: ; win + scrolllock
If (isActive = False) {
	StartWatch()
} Else {
	StopWatch()
}
Return

StartWatch(){
	global isActive
	isActive := True
	SetTimer, WatchCursor, 16 ; 1000ms/60fps =~ 16.7ms
}

StopWatch(){
	global isActive
	isActive := False
	SetTimer, WatchCursor, Off
	ToolTip ; removing tooltip
}

InitTrayMenu(){
	Menu, Tray, NoStandard ; remove default tray menu entries
	Menu, Tray, Add, Exit, Exit
}

Exit(){    
	ExitApp
}

; ----------------------------------------------------------------
; main poller
WatchCursor:
MouseGetPos, x, y, winId, controlId
return

Ctrl & Esc:: Exit() ;종료기능

LControl & LAlt:: ; KeyHistory 실행 단축키 : Ctrl + 한자
KeyHistory
return


LAlt & j:: ;영어로 변경
imeState := ReadImeState(winId)
if(imeState = 1){
	Send, {vk15sc138}
}
return

LAlt & k:: ;한글로 변경
imeState := ReadImeState(winId)
if(imeState = 0){
	Send, {vk15sc138}
}
return

; ----------------------------------------------------------------
; @returns int 0:inactive 1:active
ReadImeState(hWnd)
{
    ; WinGet,hWnd,ID,%WinTitle%
    Return Send_ImeControl(ImmGetDefaultIMEWnd(hWnd),0x005,"")
}

Send_ImeControl(DefaultIMEWnd, wParam, lParam)
{
    DetectSave := A_DetectHiddenWindows
    DetectHiddenWindows,ON
    SendMessage 0x283, wParam,lParam,,ahk_id %DefaultIMEWnd%
    if (DetectSave <> A_DetectHiddenWindows)
        DetectHiddenWindows,%DetectSave%
    return ErrorLevel
}

ImmGetDefaultIMEWnd(hWnd) { 
	return DllCall("imm32\ImmGetDefaultIMEWnd", Uint,hWnd, Uint) 
}