/*
 * E-INK WALL LABEL FOR AUTOMATIC FICTURE FRAME
 *  
 *  23/11/2020  v0.1  TEST CODE: MQTT OK but display not working
 *  30/11/2020  v0.2  2nd trial: working!!
 *  05/12/2020  v0.3  deep sleep: working but conflics with MQTT
 *  06/12/2020  v0.4  deep sleep 2nd trial: working!!
 *  06/12/2020  v0.5  battery level indicator added: failed
 *  08/12/2020  v0.6  2nd trial: failed. gave up
 *  09/12/2020  v0.7  timer update via MQTT
 *  13/12/2020  v0.8  info line added
 *  
 *  BOARD: LILIGO T5 V2.2 2.9" E INK
 *  
 *  Todo:
 *  1. 
 *  2. 
 *  3. 
 *  4. battery indicator
 *  5. 
 *  
 */

#include <GxEPD.h>
#include <GxIO/GxIO_SPI/GxIO_SPI.h>
#include <GxIO/GxIO.h>
#include <WiFi.h>
#include <PubSubClient.h>
#include <GxGDEH029A1/GxGDEH029A1.h> // 2.9" b/w

// FreeFonts from Adafruit_GFX
#include <Fonts/FreeSerifItalic12pt7b.h>  //for title 
#include <Fonts/FreeSerifBold12pt7b.h>    //for name
#include <Fonts/FreeSerif9pt7b.h>         //for info

// screen 296x128 pixels
#define SPI_MOSI        23
#define SPI_MISO        2
#define SPI_CLK         18

#define ELINK_SS        5
#define ELINK_BUSY      4
#define ELINK_RESET     12
#define ELINK_DC        19

//#define SDCARD_SS       13

#define BUTTON_1        37
#define BUTTON_2        38
#define BUTTON_3        39

//#define SPEAKER_OUT     25

uint64_t uS_TO_S_FACTOR = 1000000;  /* Conversion factor for micro seconds to seconds */
uint64_t TIME_TO_SLEEP;    

//for battery voltage
const uint8_t vbatPin = 34;

RTC_DATA_ATTR int bootCount = 0;

const char* ssid     = "xxxx";
const char* password = "yyyy";
const char* mqtt_server = "000.000.000.000";  

String line1;
String line2;
String line3;
String line4;
bool updateName = false;
bool updateTitle = false;
bool updateInfo = false;
bool updateTime = false;

float VBAT; // battery voltage from ESP32 ADC read

WiFiClient espClient;
PubSubClient client(espClient);

GxIO_Class io(SPI, ELINK_SS, ELINK_DC, ELINK_RESET);
GxEPD_Class display(io, ELINK_RESET, ELINK_BUSY);
// SPIClass sdSPI(VSPI);

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void setup()
{
    pinMode(BUTTON_1, INPUT);
    pinMode(BUTTON_2, INPUT);
    pinMode(BUTTON_3, INPUT);

    Serial.begin(115200);
    delay(1000); //Take some time to open up the Serial Monitor

    pinMode(vbatPin, INPUT);
        
    setup_wifi();
    client.setServer(mqtt_server, 1883);
    client.setCallback(callback);

    //Increment boot number and print it every reboot
    ++bootCount;
    Serial.println("Boot number: " + String(bootCount));
    
    SPI.begin(SPI_CLK, SPI_MISO, SPI_MOSI, ELINK_SS);
    display.init(); // enable diagnostic output on Serial
    display.setRotation(1);
    display.setTextColor(GxEPD_BLACK);
    
    //loop MQTT client 
    uint32_t loopStart = millis(); 
    while (millis() - loopStart < 15000) {
      if (!client.connected()) {
        reconnect();
      } 
      else {
        client.loop();
        screenUpdate();
      }
    }

    //battery check
    VBAT = (float)(analogRead(vbatPin)) * 3600 / 4095 * 2;
    Serial.print(VBAT);
    Serial.println(" Volts");
    client.publish("pictureFrame/battery", String(VBAT).c_str(),true);   

  //update wakeup timer + deep sleep
  esp_sleep_enable_timer_wakeup(TIME_TO_SLEEP * uS_TO_S_FACTOR);
  client.publish("pictureFrame/walllabel", "sleeping");
  delay(500);
  Serial.flush();
  esp_deep_sleep_start();
}

void screenUpdate(){
  if(updateName == true && updateTitle == true && updateInfo == true && updateTime == true){
    display.fillScreen(GxEPD_WHITE);
    display.setFont(&FreeSerifBold12pt7b);
    display.setCursor(10, 25);
    display.println(line1);   //name update
    display.setFont(&FreeSerifItalic12pt7b);
    display.setCursor(10, 60);
    display.println(line2);   // first title line 
    display.setCursor(10, 85);
    display.println(line3);   //sencond title line
    display.setCursor(10, 120);
    display.setFont(&FreeSerif9pt7b);   
    display.println(line4);   //info
    display.update();
    updateName = false;
    updateTitle = false;
    updateTime = false;
    updateInfo = false;
  }
}

void callback(String topic, byte* message, unsigned int length) {
  Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  String messageTemp;
  for (int i = 0; i < length; i++) {
    Serial.print((char)message[i]);
    messageTemp += (char)message[i];
  }
  Serial.println();

  if(topic=="pictureFrame/line1")
  {
    line1 = messageTemp;
    updateName = true;
  }
  
  if(topic=="pictureFrame/line2")
  {
    line2 = messageTemp;
  }
  
  if(topic=="pictureFrame/line3")
  {
    line3 = messageTemp;
    updateTitle = true;
  }

  if(topic=="pictureFrame/line4")
  {
    line4 = messageTemp;
    updateInfo = true;
  }
  
  if(topic=="pictureFrame/wakeupSeconds")
  {
    TIME_TO_SLEEP = messageTemp.toInt();
    updateTime = true;
  }
}

void loop(){
  //nothing  
}

void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
    // Create a random client ID
    String clientId = "ESP8266Client-";
    clientId += String(random(0xffff), HEX);
    // Attempt to connect
    if (client.connect(clientId.c_str())) {
      Serial.println("connected");
      // Once connected, publish an announcement...
      client.publish("pictureFrame/walllabel", "on");
      // ... and resubscribe
      client.subscribe("pictureFrame/#");
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}
